//
//  lckrwt.h
//  smbfs.kext
//
//  Created by Ethan Nelson-Moore on 5/2/19.
//

#ifndef lckrwt_h
#define lckrwt_h
#pragma pack(1)        /* Make sure the structure stays as we defined it */
typedef struct __lck_rw_t__ {
    volatile uint16_t    lck_rw_shared_count;    /* No. of accepted readers */
    volatile uint8_t    lck_rw_interlock;     /* Interlock byte */
    volatile uint8_t
lck_rw_priv_excl:1,    /* Writers prioritized if set */
lck_rw_want_upgrade:1,    /* Read-to-write upgrade waiting */
lck_rw_want_write:1,    /* Writer waiting or locked for write */
lck_r_waiting:1,    /* Reader is sleeping on lock */
lck_w_waiting:1,    /* Writer is sleeping on lock */
lck_rw_can_sleep:1,    /* Can attempts to lock go to sleep? */
lck_rw_padb6:2;         /* padding */

    uint32_t        lck_rw_tag; /* This can be obsoleted when stats
                                 * are in
                                 */
    uint32_t        lck_rw_pad8;
    uint32_t        lck_rw_pad12;
} lck_rw_t;

#pragma pack()

typedef struct __lck_mtx_t__ {
    union {
        struct {
            volatile uintptr_t        lck_mtxd_owner;
            union {
                struct {
                    volatile uint32_t
                lck_mtxd_waiters:16,
                lck_mtxd_pri:8,
                lck_mtxd_ilocked:1,
                lck_mtxd_mlocked:1,
                lck_mtxd_promoted:1,
                lck_mtxd_spin:1,
                lck_mtxd_is_ext:1,
                lck_mtxd_pad3:3;
                };
                uint32_t    lck_mtxd_state;
            };
            /* Pad field used as a canary, initialized to ~0 */
            uint32_t            lck_mtxd_pad32;
        } lck_mtxd;
        struct {
            struct _lck_mtx_ext_        *lck_mtxi_ptr;
            uint32_t            lck_mtxi_tag;
            uint32_t            lck_mtxi_pad32;
        } lck_mtxi;
    } lck_mtx_sw;
} lck_mtx_t;

#endif /* lckrwt_h */
