//
//  NDRVShim.c
//  NDRVShim
//
//  Created by Ethan Nelson-Moore on 6/9/18.
//  Copyright © 2018 parrotgeek1. All rights reserved.
//

#include <mach/mach_types.h>
#include <IOKit/IOLib.h>

kern_return_t NDRVShim_start(kmod_info_t * ki, void *d);
kern_return_t NDRVShim_stop(kmod_info_t *ki, void *d);

kern_return_t NDRVShim_start(kmod_info_t * ki, void *d)
{
    return KERN_SUCCESS;
}

kern_return_t NDRVShim_stop(kmod_info_t *ki, void *d)
{
    // I don't think that's a good idea
    return KERN_FAILURE;
}

typedef UInt32                          FourCharCode;
typedef FourCharCode                    ResType;
typedef ResType                         VSLGestaltType;


enum {
    paramErr                      = -50,  /*error in user parameter list*/
    noHardwareErr                 = -200, /*Sound Manager Error Returns*/
    notEnoughHardwareErr          = -201, /*Sound Manager Error Returns*/
    userCanceledErr               = -128,
    qErr                          = -1,   /*queue element not found during deletion*/
    vTypErr                       = -2,   /*invalid queue element*/
    corErr                        = -3,   /*core routine number out of range*/
    unimpErr                      = -4,   /*unimplemented core routine*/
    SlpTypeErr                    = -5,   /*invalid queue element*/
    seNoDB                        = -8,   /*no debugger installed to handle debugger command*/
    controlErr                    = -17,  /*I/O System Errors*/
    statusErr                     = -18,  /*I/O System Errors*/
    readErr                       = -19,  /*I/O System Errors*/
    writErr                       = -20,  /*I/O System Errors*/
    badUnitErr                    = -21,  /*I/O System Errors*/
    unitEmptyErr                  = -22,  /*I/O System Errors*/
    openErr                       = -23,  /*I/O System Errors*/
    closErr                       = -24,  /*I/O System Errors*/
    dRemovErr                     = -25,  /*tried to remove an open driver*/
    dInstErr                      = -26   /*DrvrInstall couldn't find driver in resources*/
};



/* NameRegistry error codes */
enum {
    nrLockedErr                         = -2536,
    nrNotEnoughMemoryErr                = -2537,
    nrInvalidNodeErr                    = -2538,
    nrNotFoundErr                       = -2539,
    nrNotCreatedErr                     = -2540,
    nrNameErr                           = -2541,
    nrNotSlotDeviceErr                  = -2542,
    nrDataTruncatedErr                  = -2543,
    nrPowerErr                          = -2544,
    nrPowerSwitchAbortErr               = -2545,
    nrTypeMismatchErr                   = -2546,
    nrNotModifiedErr                    = -2547,
    nrOverrunErr                        = -2548,
    nrResultCodeBase                    = -2549,
    nrPathNotFound                      = -2550,    /* a path component lookup failed */
    nrPathBufferTooSmall                = -2551,    /* buffer for path is too small */
    nrInvalidEntryIterationOp           = -2552,    /* invalid entry iteration operation */
    nrPropertyAlreadyExists             = -2553,    /* property already exists */
    nrIterationDone                     = -2554,    /* iteration operation is done */
    nrExitedIteratorScope               = -2555,    /* outer scope of iterator was exited */
    nrTransactionAborted                = -2556,        /* transaction was aborted */

    gestaltUndefSelectorErr             = -5551 /*undefined selector was passed to Gestalt*/
};

enum {
    kVSLClamshellStateGestaltType = 'clam',
};

OSStatus VSLGestalt( VSLGestaltType selector, UInt32 * response )
{
    IOReturn ret;

    if (!response)
        return (paramErr);

    *response = 0;

    switch (selector)
    {
        case kVSLClamshellStateGestaltType:
            // FIXME
           // ret = IOGetHardwareClamshellState(response);
            ret = false;
            break;
        default:
            ret = gestaltUndefSelectorErr;
            break;
    }

    return (ret);
}

